//Lab 7 : Inspect the relative stability of systems by Root-Locus.
//------------------------------------------------------------------
//Problem Statement: Draw the root locus of the system G=1/s/(s^2+1.5*s+1).
//Observe settling time of of the system with different gains.
//------------------------------------------------------------------

//------------------------------------------------------------------
// Operating System OSX (Mac) 10.14.6
// Scilab Version 6.1.0
//------------------------------------------------------------------
xdel(winsid()) // close the figure windows
clear; // clear the workspace
clc; // clear the console
//------------------------------------------------------------------
// system representation
s=%s // Laplace operator
s=poly(0,'s');

G=syslin('c',1/(s*(s^2+1.5*s+1)))   // system representation G(s)=1/(s(s^2+1.5s+1))

//Compute marginal (critical) gain
//gain margin
gm= g_margin(G);
//gm=log10(kmar) ==> kmar=10^(gm/20)
kmar=10^(gm/20)

kmax=2 // maximum gain for ploting of root locus
evans(G,kmax)
xgrid
// for various k, system transfer functions are
k1=0.4
G1=k1*G/(1+k1*G)         //G1=0.4/(s^3+1.5s^2+s+0.4)
[z1,p1,k1]=tf2zp(G1)
plot(real(p1),imag(p1),'bx')

k2=0.8
G2=k2*G/(1+k2*G)        //G2=0.8/(s^3+1.5s^2+s+0.8)

[z2,p2,k2]=tf2zp(G2)
plot(real(p2),imag(p2),'gx')

k3=kmar                 //kmar=1.5
G3=k3*G/(1+k3*G)        //G1=0.4/(s^3+1.5s^2+s+1.5)

[z3,p3,k3]=tf2zp(G3)
plot(real(p3),imag(p3),'cx')
//------------------------------------------------------------------
// Unit step response
t=0:0.1:40            // Simulation time
dim=size(t);

u=ones(dim(1),dim(2)) // unit step input

c1=csim(u,t,G1)  // Response of system G with k1
c2=csim(u,t,G2)  // Response of system G2 with k2
c3=csim(u,t,G3)  // Response of system G2 with k3

//plots 
figure(1)
clf
plot(t,c1,t,c2,t,c3,'c:','LineWidth',2)
xgrid

//Title, labels and grid to the figure
legend('k=0.4','k=0.8', 'k=1.5',4)
title('Responses of system with different gains' ,'fontsize',3)
xlabel('Time t (sec.)','fontsize',2)
ylabel('c(t)','fontsize',2)
